# -*- coding: utf-8 -*-
"""r06.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/16FIbfR_claBE_JIx5Tzm5bw3hCN-jUTu
"""

import numpy as np
import matplotlib.pyplot as plt
import scipy.linalg
from scipy.linalg import toeplitz


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Przestrzeń kolumnowa"""

A  = np.array([ [1],[3] ])

xlim = [-5,5]
colspace_p1 = xlim[0]*A
colspace_p2 = xlim[1]*A

plt.figure(figsize=(6,6))

plt.plot([0,A[0,0]],[0,A[1,0]],'k',linewidth=4,label='A')
plt.plot([colspace_p1[0,0],colspace_p2[0,0]],[colspace_p1[1,0],colspace_p2[1,0]],
         '--',linewidth=3,color=[.7,.7,.7],label='C(A)')
plt.xlim(xlim)
plt.ylim(xlim)
plt.legend()
plt.grid()
plt.savefig('rys6.1.png',dpi=300)
plt.show()

A1  = np.array([ [1,1],[3,2] ])
A2  = np.array([ [1,2],[3,6] ])

xlim = [-6,6]
color = [ [0,0,0],[.7,.7,.7] ]


_,axs = plt.subplots(1,2,figsize=(12,6))

for i in range(2):
  axs[0].plot([0,A1[0,i]],[0,A1[1,i]],color=color[i],linewidth=4)
  axs[1].plot([0,A2[0,i]],[0,A2[1,i]],color=color[i],linewidth=4,zorder=-i)

  axs[i].set_xlim(xlim)
  axs[i].set_ylim(xlim)
  axs[i].grid()
  axs[i].text(xlim[0]-.7,xlim[1]+.5,f'{"AB"[i]})',fontweight='bold',fontsize=16)

for i in [0,1]: axs[i].legend([f'A{i+1}$_{{[:,0]}}$',f'A{i+1}$_{{[:,1]}}$'])

plt.savefig('rys6.2.png',dpi=300)
plt.show()



"""# Przykład w R^3"""

A = np.array( [ [3,0],
                [5,2],
                [1,2] ] )

ax = plt.figure(figsize=(6,6)).add_subplot(111, projection='3d')

xx, yy = np.meshgrid(np.linspace(-5,5,10),np.linspace(-5,5,10))
cp = np.cross(A[:,0],A[:,1])
z1 = (-cp[0]*xx - cp[1]*yy)/cp[2]
ax.plot_surface(xx,yy,z1,alpha=.2)


ax.plot([0, A[0,0]],[0, A[1,0]],[0, A[2,0]],color=color[0],linewidth=4)
ax.plot([0, A[0,1]],[0, A[1,1]],[0, A[2,1]],color=color[1],linewidth=4)

plt.savefig('rys6.3.png',dpi=300)
plt.show()



"""# Jądro

"""

A = np.array([ [1,-1],[-2,2] ])
B = np.array([ [1,-1],[-2,3] ])

print( scipy.linalg.null_space(A) )
print(' ')

print( scipy.linalg.null_space(B) )

nullvect = scipy.linalg.null_space(A)



xlim = [-3,3]
color = [ [0,0,0],[.7,.7,.7] ]


plt.figure(figsize=(6,6))

for i in range(2):
  plt.plot([0,A[i,0]],[0,A[i,1]],color=color[i],linewidth=4,label='A$_{{[%g,:]}}$'%i)

plt.plot([0,nullvect[0,0]],[0,nullvect[1,0]],'--',color=[.4,.4,.4],
         linewidth=4,label='y')

plt.plot([xlim[0]*nullvect[0,0],xlim[1]*nullvect[0,0]],
         [xlim[0]*nullvect[1,0],xlim[1]*nullvect[1,0]],
         ':',color=[.4,.4,.4],label='ker(A)')

plt.xlim(xlim)
plt.ylim(xlim)
plt.grid()
plt.legend()

plt.savefig('rys6.4.png',dpi=300)
plt.show()





"""# Ćwiczenie 1."""

# symulacja
scalingVals = np.linspace(0,50,40) # 40 wartości z zakresu 0-50
nExperiments = 10


# inicjalizacja macierzy wyników
matrixNorms = np.zeros((len(scalingVals),nExperiments))

# uruchomienie eksperymentu!
for si in range(len(scalingVals)):
  for expi in range(nExperiments):

    # generowanie losowych macierzy i ich skalowanie
    R = np.random.randn(10,10) * scalingVals[si]

    # zapisywanie obliczonej normy
    matrixNorms[si,expi] = np.linalg.norm(R,'fro')


# wykreślanie wyników
plt.plot(scalingVals,np.mean(matrixNorms,axis=1),'ko-')
plt.xlabel('Wartość skalara')
plt.ylabel('Norma Frobeniusa')
plt.savefig('rys6.7.png',dpi=300)
plt.show()

# sprawdzenie, czy macierze zerowe mają normę Frobeniusa równą 0
print(matrixNorms[0,:])



"""# Ćwiczenie 2."""

# funkcja obliczająca odległość euklidesową

def EuclideanDistance(M1,M2):

  # różnica macierzy
  D = M1-M2

  # macierz odległości
  return np.sqrt(np.sum(D**2))

# kod znajdujący skalar

# tworzę dwie macierze
N = 7
A = np.random.randn(N,N)
B = np.random.randn(N,N)

# znajdowanie szukanej wartości
numIters = 0
s = 1
while EuclideanDistance(s*A,s*B)>1:
  s *= .9
  numIters += 1

# wyświetlanie wyników
# zauważ, że w mojej pętli przeprowadzam o jedno skalowanie więcej niż potrzeba
# z tego powodu odejmuję jeden od NumIters oraz cofam ostatnie przeskalowanie
print(f'Liczba iteracji: {numIters-1}')
print(f'Wartość skalara: {s/.9:.3f}')
print(f'Odległość euklidesowa dla znalezionego skalara: {EuclideanDistance(s/.9*A,s/.9*B):.3f}')

# poniższy kod nie jest częścią ćwiczenia, ale powtórzyłem obliczenia 1000 razy, aby zbadać rozkład wartości NumIters


nIters = np.zeros(1000)

for i in range(1000):
  # tworzę dwie macierze
  A = np.random.randn(N,N)
  B = np.random.randn(N,N)

  numIters,s = 0,1
  while EuclideanDistance(s*A,s*B)>1:
    s *= .9
    numIters += 1
  nIters[i] = numIters-1

plt.hist(nIters)
plt.xlabel('Liczba iteracji')
plt.ylabel('Liczność');



"""# Ćwiczenie 3."""

# tworzę macierz
M = 50
A = np.random.randn(M,M)

# metoda z użyciem śladu
norm1 = np.sqrt(np.sum(np.diag(A.T@A)))

# odległość euklidesowa
norm2 = np.sqrt(np.sum(A**2))

# jeżeli oba sposoby dają ten sam wynik, to różnica między wynikami powinna być bliska 0
norm1-norm2



"""# Ćwiczenie 4."""

# rozmiar macierzy
N = 10

shifting = np.linspace(0,1,30)

# oryginalna macierz
A = np.random.randn(N,N)
normA = np.linalg.norm(A,'fro')

# inicjalizacja macierzy wyników
shiftingResults = np.zeros( (len(shifting),3) )
resultsNames = [ 'Zmiana w normie (%)','Korelacja z oryg. macierzą','Norma Frobeniusa' ]



for si in range(len(shifting)):

  # przesunięcie macierzy
  As = A + shifting[si]*normA*np.eye(N)

  # obliczenie nowej wartości normy i ułamka, o który ma nastąpić przesunięcie
  normShift = np.linalg.norm(As,'fro')
  shiftingResults[si,0] = 100 * (normShift-normA)/normA

  # obliczanie korelacji
  shiftingResults[si,1] = np.corrcoef(A.flatten(),As.flatten())[0,1]

  # obliczanie odległości Frobeniusa
  shiftingResults[si,2] = EuclideanDistance(A,As)




## tworzenie wykresu!
_,axs = plt.subplots(1,3,figsize=(12,4))

for i in range(3):


  axs[i].plot(shifting,shiftingResults[:,i],'ks-')
  axs[i].set_xlabel('Przesunięcie (jako ułamek normy)')
  axs[i].set_ylabel(resultsNames[i])

plt.tight_layout()
plt.savefig('rys6.8.png',dpi=300)
plt.show()



"""# Ćwiczenie 5."""

# tworzenie macierzy o określony rzędzie i rozmiarze

M = 5
N = 8
r = 3

A = np.random.randn(M,r) @ np.random.randn(r,N)

print(A.shape)
print(np.linalg.matrix_rank(A))



"""# Ćwiczenie 6."""

# suma ma rząd równy 0

A = np.diag([ 1,0,0,0,0])
B = np.diag([-1,0,0,0,0])
C = A+B

# wyświetlam rzędy
np.linalg.matrix_rank(A),np.linalg.matrix_rank(B),np.linalg.matrix_rank(C)

# suma ma rząd równy 1

A = np.diag([1,0,0,0,0])
B = np.zeros(A.shape)
B[0,1] = 10
C = A+B

# wyświetlam rzędy
np.linalg.matrix_rank(A),np.linalg.matrix_rank(B),np.linalg.matrix_rank(C)

# suma ma rząd równy 1

A = np.diag([1,0,0,0,0])
B = np.diag([0,1,0,0,0])
C = A+B

# wyświetlam rzędy
np.linalg.matrix_rank(A),np.linalg.matrix_rank(B),np.linalg.matrix_rank(C)

# macierze wartości losowych mają możliwie najwyższy rząd!
A = np.random.randn(5,1) @ np.random.randn(1,5)
B = np.random.randn(5,1) @ np.random.randn(1,5)
C = A+B

# wyświetlam rzędy
np.linalg.matrix_rank(A),np.linalg.matrix_rank(B),np.linalg.matrix_rank(C)



"""# Ćwiczenie 7."""

# funkcja
def makeAmatrix(M,r):
  return np.random.randn(M,r) @ np.random.randn(r,M)


# parametry
matSize = 20 # rozmiar macierzy (macierz jest kwadratowa)
rs = range(2,16) # rzędy macierzy

# inicjalizacja macierzy wyników
Ranks = np.zeros((len(rs),len(rs),2))

# uruchomienie symulacji
for i in range(len(rs)):
  for j in range(len(rs)):

    # tworzenie macierzy
    S = makeAmatrix(matSize,rs[i]) + makeAmatrix(matSize,rs[j])
    M = makeAmatrix(matSize,rs[i]) @ makeAmatrix(matSize,rs[j])

    # obliczanie ich rzędów
    Ranks[i,j,0] = np.linalg.matrix_rank(S)
    Ranks[i,j,1] = np.linalg.matrix_rank(M)



## wizualizacja
fig,axs = plt.subplots(1,2,figsize=(10,6))
s = '+@' # symbole do tytułów wykresów

for i in range(2):

  # rysowanie mapy ciepła
  h = axs[i].imshow(Ranks[:,:,i],vmin=np.min(rs),vmax=np.max(rs),origin='lower',
                    extent=(rs[0],rs[-1],rs[0],rs[-1]),cmap='gray')

  # dodawanie paska kolorów i poprawa wyglądu wykresu
  fig.colorbar(h,ax=axs[i],fraction=.045)
  axs[i].set_xlabel('Rząd A')
  axs[i].set_ylabel('Rząd B')
  axs[i].set_title(f'Rząd A{s[i]}B')

plt.tight_layout()
plt.savefig('rys6.9.png',dpi=300, bbox_inches = 'tight')
plt.show()



"""# Ćwiczenie 8."""

# parametry
M = 15
N = 8
r = 4

# wyznaczam cztery macierze
A   = np.random.randn(M,r) @ np.random.randn(r,N)
At  = A.T
AtA = A.T@A
AAt = A@A.T

# wyświetlam ich rzędy
print(
    np.linalg.matrix_rank(A),
    np.linalg.matrix_rank(At),
    np.linalg.matrix_rank(AtA),
    np.linalg.matrix_rank(AAt)
)



"""# Ćwiczenie 9."""

def is_V_inColA(A,v):

  # sprawdzenie rozmiaru
  if A.shape[0]!=v.shape[0]:
    raise Exception('Niezgodność wymiarów! A i v muszą mieć taką samą liczbę kolumn!')

  # obliczanie rzędów
  rankA  = np.linalg.matrix_rank(A)
  rankAv = np.linalg.matrix_rank( np.hstack((A,v)) )

  # funkcja zwraca TRUE jeżeli v należy do C(A)
  return rankA==rankAv


# tworzę macierz i wektor
A = np.random.randn(4,3)
v = np.random.randn(4,1)

# test!
is_V_inColA(A,v)



"""# Ćwiczenie 10."""

# rozmiary macierzy
ns = np.arange(3,31)

# liczba iteracji
iters = 100

# inicjalizacja
dets = np.zeros((len(ns),iters))

# pętla po rozmiarach macierzy
for ni in range(len(ns)):
  for i in range(iters):

    # krok 1.
    A = np.random.randn(ns[ni],ns[ni])

    # krok 2.
    A[:,0] = A[:,1]

    # krok 3.
    dets[ni,i]=np.abs(np.linalg.det(A))


# uwaga: liczba elementów w macierzy kwadratowej to liczba kolumn podniesiona do kwadratu


# wykreślanie wyników
plt.figure(figsize=(6,4))
plt.plot(ns**2,np.log(np.mean(dets,axis=1)),'ks-',linewidth=3)
plt.xlabel('Liczba elementów w macierzy')
plt.ylabel('Logarytm z wyznacznika')
plt.title('Wyznaczniki macierzy osobliwych')
plt.savefig('rys6.10.png',dpi=300, bbox_inches='tight')
plt.show()

